import java.awt.*;
import java.awt.geom.*;
import javax.swing.*;
import java.util.*;

public class PressureView4 extends JPanel {
	private ArrayList<Integer>	vals;
	private int chartHeight= 800;
	private int chartWidth= 1000;
	private int chartMax= 1000;

	public PressureView4(){
		vals = new ArrayList<Integer>();
		setBackground(Color.lightGray);
		setPreferredSize(new Dimension(chartWidth, chartHeight));
	}
	
	public void updateChart(int newVal){
		vals.add(newVal);
		repaint(); 
	}
	
	private Path2D getGraphPath() {
		int nVals=vals.size();
		int rows= nVals/chartWidth +1;
		int rowHeight= chartHeight/rows;
		double chartScale= (double) rowHeight / chartMax;
		Path2D p = new Path2D.Double();
		int x= -1;
		int rowY= rowHeight;
		try {
			if (!vals.isEmpty())
				p.moveTo(x, rowHeight - chartScale * vals.get(0));
			for (int i : vals ) {
				if ( ++x == chartWidth) {
					x= 0;
					rowY += rowHeight;
					p.moveTo( x, rowY - chartScale * i);
				} else
					p.lineTo(x, rowY - chartScale * i);
			}
		} catch (ConcurrentModificationException ce) {
			System.err.println("Corrupted data!");
			System.exit(1);
		}
		return p;
	}

	public void paintComponent(Graphics g) {
		super.paintComponent(g);
		Graphics2D g2 = (Graphics2D) g;
		g2.setPaint(Color.blue);
		g2.setStroke(new BasicStroke(2));
		Path2D p= getGraphPath();
		g2.draw( p );
	}
}